#version 150

/**
 * © Janus Bager Kristensen & Rolf Bagge, CAVI Aarhus University, 2014
 */

uniform sampler2D texture;
uniform float threshold;
uniform bool binary;

in vec2 texCoord;

void main() {
    float gray = texture2D(texture, texCoord).r;

    float c = gray - threshold;

    if(!binary) {
        c = max(0.0, c);
        c = c/(1.0-threshold);
        gray *= c;
    } else {
        c = max(0.0, c);
        c = ceil(c);
        gray = c;
    }


    gl_FragColor = vec4(gray,gray,gray,1);
}