#version 150

/**
 * © Janus Bager Kristensen & Rolf Bagge, CAVI Aarhus University, 2014
 */

uniform sampler2D extractedCenters;
uniform sampler2D originalGrayscale;

uniform float radius;
uniform float fingerRadius;
uniform float ringSize;

const int circleSteps = 256;
const int circleStepsPrecise = 1080; // How many steps around a FULL circle
const float pi = 3.1415926535;
const float twopi = 3.1415926535 * 2.0;
const float piStep = (2.0 * pi) / circleSteps;
const float precisePiStep = (2.0 * pi) / circleStepsPrecise;

//360 degrees on circle, so 36 steps is 10 degrees
const float tenDegrees = (2 * pi) / 36;

smooth in vec2 texCoord;

out vec4 outColor;

vec2 radiansToUV(float radians, vec2 circleCenter, float radius) {
    vec2 textureUnits = 1.0 / textureSize(originalGrayscale, 0);

    vec2 circleUV;
    circleUV.x = circleCenter.x + radius * cos(radians) * textureUnits.x;
    circleUV.y = circleCenter.y + radius * sin(radians) * textureUnits.y;

    return circleUV;
}

void main()
{
    vec4 center = texture(extractedCenters, texCoord);

    outColor = vec4(0);
    vec2 circleCenterUV = center.xy;

    if(center.a > 1.0) {
        // For fingers just approximate the largest two-point rotation (the point where the diff to the opposite side is most positive)        
        float bestDiff = -1;
        float bestRotation = -1; 
        for(float r = 0; r < twopi; r+= piStep) {
            float sampleRadians = r;
            float oppositeSampleRadians = r + pi;
            float diff = texture(originalGrayscale, radiansToUV(sampleRadians, circleCenterUV, 1.6*fingerRadius)).r // should be white
                        -texture(originalGrayscale, radiansToUV(oppositeSampleRadians, circleCenterUV, 1.3*fingerRadius)).r; // should be black
            if (diff > bestDiff){
                bestDiff = diff;
                bestRotation = r;
            }
        }       

        // Now find a more precise weighted blob center
        float startRadians = bestRotation - 2*tenDegrees;
        float endRadians = bestRotation + 2*tenDegrees;
        vec2 result = vec2(0);
        for(float r = startRadians; r < endRadians; r+= 2*precisePiStep) {
            float sampleRadians = r;
            float oppositeSampleRadians = r + pi;
            float diff = texture(originalGrayscale, radiansToUV(sampleRadians, circleCenterUV, 1.8*fingerRadius)).r // should be white
                        -texture(originalGrayscale, radiansToUV(oppositeSampleRadians, circleCenterUV, 1.6*fingerRadius)).r; // should be black

            result += vec2(r*diff, diff);
        }
        //Average over the totalValue number
        result.x = result.x / result.y;
        result.x = pi+twopi-result.x;
        if (result.x > twopi) result.x -= twopi;        
        outColor = vec4(result.x, 0.0, 1.0, 1.0);
    }
}
