#version 150

/**
 * © Janus Bager Kristensen & Rolf Bagge, CAVI Aarhus University, 2014
 */

uniform sampler2D centerTexture;
uniform sampler2D idTexture;
uniform sampler2D rotationTexture;

smooth in vec2 texCoord;

out vec4 fragOut;

void main() {
    fragOut = vec4(0,0,0,0);

    vec4 center = texture(centerTexture, texCoord);

    if(center.a > 0) {
        vec4 id = texture(idTexture, texCoord);
        vec4 rotation = texture(rotationTexture, texCoord);

        //TODO: Make some king of filtering

        fragOut = vec4(center.rg, id.r, rotation.r);
    }
}