#version 150

/**
 * © Janus Bager Kristensen & Rolf Bagge, CAVI Aarhus University, 2014
 */

uniform sampler2D finalTexture;
uniform sampler2D debugTexture;
uniform sampler2D cameraTexture;

const int largeWidth = %HD_WIDTH%;
const int largeHeight = %HD_HEIGHT%;
const int smallWidth = %CAM_WIDTH%;
const int smallHeight = %CAM_HEIGHT%;

const float totalWidth = largeWidth * 3;
const float largeFrac = largeWidth / totalWidth;
const float smallFrac = smallWidth / totalWidth;
const float smallHeightFrac = smallHeight / float(largeHeight);

smooth in vec2 texCoord;

out vec4 fragOut;

//Monitor Setup
/**
 *    1920             1920            1920          
 *  1 --------------   -------------   ------------- 
 *  0 |            |   |           |   |           | 
 *  8 |   Final    |   |   Debug   |   |   Final   | 
 *  0 | (Recorder) |   |           |   |           | 
 *    --------------   -------------   ------------- 
 * 
 */

void main() {
    if(texCoord.x < largeFrac) {
        vec2 correctedTexCoord = texCoord;
        correctedTexCoord.x /= largeFrac;

        vec4 final = texture(finalTexture, correctedTexCoord);
        fragOut = final;
    } else if(texCoord.x < largeFrac * 2) {
        vec2 correctedTexCoord = texCoord;
        correctedTexCoord.x -= largeFrac;
        correctedTexCoord.x /= largeFrac;

        vec4 debug = texture(debugTexture, correctedTexCoord);
        fragOut = debug;
    }else {
        vec2 correctedTexCoord = texCoord;
        correctedTexCoord.x -= largeFrac * 2;
        correctedTexCoord.x /= largeFrac;

        vec4 debug = texture(finalTexture, correctedTexCoord);
        fragOut = debug;
    }
}