#version 150
#extension GL_EXT_geometry_shader4 : enable

/**
 * © Janus Bager Kristensen & Rolf Bagge, CAVI Aarhus University, 2014
 */

uniform sampler2D texture;

layout (triangles) in;
layout (triangle_strip, max_vertices = 3) out;

smooth in vec2 texCoord[];
smooth out vec2 fs_texCoord;
out float normalizedScale;

void main() {
    vec2 textureSize = vec2(%WIDTH%, %HEIGHT%);
    vec2 textureUnits = 1.0 / textureSize;

    float maxGray = 0;

    for( int x = 0 ; x < %WIDTH%; x++) {
        for( int y = 0 ; y < %HEIGHT%; y++) {
            vec2 uv = vec2(x,y) * textureUnits;

            float gray = texture2D(texture, uv).r;

            maxGray = max(gray, maxGray);
        }
    }

    normalizedScale = 1.0 / maxGray;

    for( int i = 0 ; i < gl_in.length() ; i++ )
    {
        gl_Position   = gl_in[i].gl_Position;
        fs_texCoord = texCoord[ i ];
        EmitVertex();
    }
}