#version 150
#extension GL_EXT_geometry_shader4 : enable

/**
 * © Janus Bager Kristensen & Rolf Bagge, CAVI Aarhus University, 2014
 */

/**
 * Find the blob that has the highest likelyhood of being the center of a
 * motion-blurred tag within a given distance of a point.
 * Idea: Candidates closer to the point are weighted higher than candidates far away.
 * Idea: Candidates closer to a given direction are weighted higher than candidates in the orthogonal directions
 */

layout(points) in;
layout(points, max_vertices = 1) out; // also the width of the output texture

uniform sampler2D tex;
float quarterPi = 0.785398163;
out vec4 theResult;

void main() {
    // Find the search area and texture info
    vec2 center = gl_in[0].gl_Position.xy;
    vec2 textureSize = textureSize(tex, 0);
    vec2 textureUnits = 1.0 / textureSize;

    // Search for candidates
    vec4 bestCandidate = vec4(0,0,0,0);
    vec4 candidate = vec4(0,0,0,0);
    for (float angle = %MIN_ANGLE%; angle < %MAX_ANGLE%; angle += %ANGLE_STEP_SIZE%){                           // In a cirle around the point (in radians)
        vec2 angleUnitVector = vec2(cos(angle) * textureUnits.x, sin(angle) * textureUnits.y);
        vec2 angleOrthogonalUnitVector = vec2(cos(angle-quarterPi) * textureUnits.x, sin(angle-quarterPi) * textureUnits.y);
        for (float distance = %MIN_DISTANCE%; distance < %MAX_DISTANCE%; distance += %DISTANCE_STEP_SIZE%){     // At different distances (in pixels)
            // Sample outside-left, left ring, right, outside-right. Add white points subtract black points
            vec2 samplingPoint = center + distance*angleUnitVector;
            candidate = -texture(tex, samplingPoint - %OUTSIDE_RADIUS%*angleOrthogonalUnitVector);              // Sample 4 points along the normal to the expected motion blur
            candidate += texture(tex, samplingPoint - %OUTER_RADIUS%*angleOrthogonalUnitVector);                // (orthogonally to a line away from the center point)
            candidate += texture(tex, samplingPoint + %OUTER_RADIUS%*angleOrthogonalUnitVector);                // since this is the only direction that a motion blur will preserve
            candidate -= texture(tex, samplingPoint + %OUTSIDE_RADIUS%*angleOrthogonalUnitVector);              // spatial data in.

            // Compare with old best
            if (candidate.x + candidate.y + candidate.z > bestCandidate.a){
                bestCandidate.a = candidate.x + candidate.y + candidate.z;
                bestCandidate.xy = samplingPoint;
            }
        }
    }

    // Emit the best candidate
    gl_Position = vec4(0.5, 0.5, 0, 1);
    theResult = bestCandidate;
    EmitVertex();
}