#version 150

/**
 * © Janus Bager Kristensen & Rolf Bagge, CAVI Aarhus University, 2014
 */

/**
 * Use one (float) texture to lookup the sampling point of another (normal) texture.
 * This is useful to warp-move a picture into another one.
 */

uniform sampler2D lookupTexture;

uniform float minX;
uniform float minY;
uniform float maxX;
uniform float maxY;

smooth in vec2 texCoord;

out vec4 fragOut;

void main() {
    vec4 color = texture(lookupTexture, texCoord);

    if(color.b > 0) {
        vec2 texSize = textureSize(lookupTexture, 0);
        vec2 texUnit = 1.0 / texSize;
        
        vec4 neighbour = texture(lookupTexture, texCoord + vec2(0, texUnit.y));
        if(neighbour.b < 1) {
            fragOut = vec4(neighbour.rg,0,1);
            return;
        }

        neighbour = texture(lookupTexture, texCoord + vec2(0, -texUnit.y));
        if(neighbour.b < 1) {
            fragOut = vec4(neighbour.rg,0,1);
            return;
        }

        neighbour = texture(lookupTexture, texCoord + vec2(texUnit.x, 0));
        if(neighbour.b < 1) {
            fragOut = vec4(neighbour.rg,0,1);
            return;
        }

        neighbour = texture(lookupTexture, texCoord + vec2(-texUnit.x, 0));
        if(neighbour.b < 1) {
            fragOut = vec4(neighbour.rg,0,1);
            return;
        }

        neighbour = texture(lookupTexture, texCoord + vec2(texUnit.x, texUnit.y));
        if(neighbour.b < 1) {
            fragOut = vec4(neighbour.rg,0,1);
            return;
        }

        neighbour = texture(lookupTexture, texCoord + vec2(-texUnit.x, texUnit.y));
        if(neighbour.b < 1) {
            fragOut = vec4(neighbour.rg,0,1);
            return;
        }

        neighbour = texture(lookupTexture, texCoord + vec2(texUnit.x, -texUnit.y));
        if(neighbour.b < 1) {
            fragOut = vec4(neighbour.rg,0,1);
            return;
        }

        neighbour = texture(lookupTexture, texCoord + vec2(-texUnit.x, -texUnit.y));
        if(neighbour.b < 1) {
            fragOut = vec4(neighbour.rg,0,1);
            return;
        }
    }

    fragOut = color;
}