#version 150

/**
 * © Janus Bager Kristensen & Rolf Bagge, CAVI Aarhus University, 2014
 */

uniform sampler2D extractedCenters;
uniform sampler2D extractedRotations;
uniform sampler2D originalGrayscale;

uniform float radius;
uniform float ringSize;

const vec2[] samplePoints = vec2[%BIT_SAMPLE_POINTS_ARRAY_COUNT%](%BIT_SAMPLE_POINTS_ARRAY%); // In big-endian order
const float samplingRadians = 0.04; // 2.4 degrees in each direction
const float samples = 2; // Samples to take in samplingRadians radians in each direction
const float pi = 3.1415926535;

smooth in vec2 texCoord;

out vec4 outColor;

vec2 radiansToUV(float radians, vec2 circleCenter, float radius) {
    vec2 textureUnits = 1.0 / textureSize(originalGrayscale, 0);

    vec2 circleUV;
    circleUV.x = circleCenter.x + radius * cos(radians) * textureUnits.x;
    circleUV.y = circleCenter.y + radius * sin(radians) * textureUnits.y;

    return circleUV;
}

void main() {
    vec4 center = texture(extractedCenters, texCoord);
    float noise = 0;

    outColor = vec4(0);

    if (center.a > 1.00001){
        outColor = vec4(-1,0.0,1.0,1.0);
    } else if(center.a > 0.0) {
        vec2 textureUnits = 1.0 / textureSize(originalGrayscale, 0);

        //Rotation finder returns radians, precision, so angle is in r
        float rotation = 2.0 * pi - texture(extractedRotations, texCoord).r;

        // Gather colours for relative colour matching (this may need to be multisample if there is too much noise)
        float white = (texture(originalGrayscale, center.xy).r + texture(originalGrayscale, radiansToUV(0, center.xy, radius - ringSize)).r) / 2.0; // Sample white from center
        float black = (texture(originalGrayscale, radiansToUV(0, center.xy, ringSize)).r + texture(originalGrayscale, radiansToUV(pi/4.0, center.xy, ringSize)).r) / 2.0;
        float average = (white+black)/2.0;

        // Construct the ID
        uint id = 0u;

        for (int i = 0; i<samplePoints.length(); i++){
            float originalRotation = 2.0 * pi - (samplePoints[i].x - pi / 4.0);
            vec2 segmentLocation = radiansToUV(originalRotation + rotation, center.xy, samplePoints[i].y*radius);  // r2UV(radian, center, radius);
            float sampleColour = texture(originalGrayscale, segmentLocation).r;

            id = id<<1u;
            // Detect if this was a white bit or a black bit
            if (sampleColour > average){
                // A "1" bit
                id++;
                noise = max(noise, abs(sampleColour-white));
            } else {
                noise = max(noise, abs(sampleColour-black));
            }
        }

        outColor = vec4(id, noise, 1.0, 1.0);
    }
}
