#version 150

/**
 * © Janus Bager Kristensen & Rolf Bagge, CAVI Aarhus University, 2014
 */

uniform sampler2D tex;
uniform int gridSize;

smooth in vec2 texCoord;

out vec4 fragOut;

void main() {
    vec2 coords = texCoord * textureSize(tex, 0);

    vec4 color = texture(tex, texCoord);

    if( mod(coords.x, gridSize) < 1 || mod(coords.y, gridSize) < 1) {
        color.r = 1;
    }
    fragOut = color;
}