#version 110

/**
 * © Janus Bager Kristensen & Rolf Bagge, CAVI Aarhus University, 2014
 */

varying vec2 texCoord;
uniform sampler2D colorMap;
uniform float blurSize;

void main() {
    vec3 sum = vec3(0.0);

    sum += texture2D(colorMap, vec2(texCoord.x - 4.0*blurSize, texCoord.y)).rgb * 0.05;
    sum += texture2D(colorMap, vec2(texCoord.x - 3.0*blurSize, texCoord.y)).rgb * 0.09;
    sum += texture2D(colorMap, vec2(texCoord.x - 2.0*blurSize, texCoord.y)).rgb * 0.12;
    sum += texture2D(colorMap, vec2(texCoord.x - blurSize, texCoord.y)).rgb * 0.15;
    sum += texture2D(colorMap, vec2(texCoord.x, texCoord.y)).rgb * 0.16;
    sum += texture2D(colorMap, vec2(texCoord.x + blurSize, texCoord.y)).rgb * 0.15;
    sum += texture2D(colorMap, vec2(texCoord.x + 2.0*blurSize, texCoord.y)).rgb * 0.12;
    sum += texture2D(colorMap, vec2(texCoord.x + 3.0*blurSize, texCoord.y)).rgb * 0.09;
    sum += texture2D(colorMap, vec2(texCoord.x + 4.0*blurSize, texCoord.y)).rgb * 0.05;

    gl_FragColor = vec4(sum,1);
}