#version 150

/**
 * © Janus Bager Kristensen & Rolf Bagge, CAVI Aarhus University, 2014
 */

//From OpenGL
uniform bool flip;
uniform bool flipVert;

in vec4 vertex;

//To fragment shader
smooth out vec2 texCoord;
smooth out vec2 texCoordNonFlipped;

void main() {
    gl_Position = vec4(vertex.xy, 0, 1);
    texCoord = vertex.xy * 0.5 + 0.5;
    texCoordNonFlipped = vertex.xy * 0.5 + 0.5;

    if(flip) {
        texCoord.y = 1-texCoord.y;
    }

    if(flipVert) {
        texCoord.x = 1-texCoord.x;
    }
}