#version 150

/**
 * © Janus Bager Kristensen & Rolf Bagge, CAVI Aarhus University, 2014
 */

/**
 * Return a grayscale image with red signifying points that have a
 * finger around them.
 */

uniform sampler2D texture;

const float radius = %RADIUS%;
const float sensitivity = %SENSITIVITY%;
const float factor = %FILTER%;

const int rings = 4; // Number of sampling rings
const int circleSteps = 16; // The numer of samples to take
const float pi = 3.1415926535;
const float piStep = (2.0 * pi) / circleSteps;

const float minThreshold = %MIN_CENTER_BRIGHTNESS%; // Circles with centers on average darker than this will not be included

smooth in vec2 texCoord;
out vec4 fragColor;

void main() {
    vec2 uv = texCoord;
    float original = texture2D(texture,uv).r;

    vec2 textureSize = textureSize(texture, 0);
    vec2 textureUnits = 1.0 / textureSize;

    if(original < minThreshold) {
        fragColor = vec4(0);
        return;
    } else {
        int samples = 0;

        float totalColor = 0;
        float totalOutsideColor = 0;

        float ringSpacing = radius / rings;
        float currentOuterRadius = radius + ringSpacing*2;

        for(int i = 0; i<circleSteps; i++) {
            float radians = i * piStep;
            vec2 directionVector = vec2(cos(radians) * textureUnits.x, sin(radians) * textureUnits.y);
            
            float currentInnerRadius = 0;

            //Sample outside
            float outsideCol = texture2D(texture, uv + currentOuterRadius * directionVector).r;
            totalOutsideColor += outsideCol;

            if (outsideCol==0) continue;

            //Optimized for loop
            for(int j = 0; j<rings; j++) {
                currentInnerRadius += ringSpacing;

                //Sample inside
                float insideColor = texture2D(texture, uv + currentInnerRadius * directionVector).r;
                totalColor += (insideColor-outsideCol);

                samples++;
            }

        }
        totalColor /= samples;
        totalOutsideColor /= circleSteps;

        fragColor = vec4(max(totalColor,0) * sensitivity, 0, totalOutsideColor * factor, 2.0);
    }
}
