#version 150
#extension GL_EXT_geometry_shader4 : enable

/**
 * © Janus Bager Kristensen & Rolf Bagge, CAVI Aarhus University, 2014
 */

/**
 * Find the first pixels and write their values to a 2D array
 */

layout(points) in;
layout(points, max_vertices = %MAX_RESULTS_PER_BLOCK%) out; // also the width of the output texture

uniform sampler2D tex;
const vec2 size = vec2(%BLOCK_WIDTH%,%BLOCK_HEIGHT%);
const int maxResultsPerBlock = %MAX_RESULTS_PER_BLOCK%;
const int maxBlocks = %MAX_BLOCKS%;

out vec4 center;

void main() {
    //Find the search area
    vec2 start = gl_in[0].gl_Position.xy;
    vec2 stop = start + size;

    //Calculate in which line (a.k.a. the current block number) to output the results
    vec2 texSize = textureSize(tex, 0);
    vec2 texUnit = 1.0 / texSize;
    
    int blocksPerLine = int(ceil(texSize.x / size.x));
    int currentBlockNumber = int(start.y / size.y) * blocksPerLine + int(start.x / size.x);
    float outputLine = -1 + (currentBlockNumber+0.5) * (2.0/maxBlocks);

    //Setup arrays to hold fingers and tags
    vec4 outputs[maxResultsPerBlock*2];

    int maxTagPosition = 0;
    int maxFingerPosition = maxResultsPerBlock;

    int foundOutputs = 0;

    //Search for the pixels in this block
    for(float x = start.x; x<stop.x; x++) {
        for(float y = start.y; y<stop.y; y++) {
            if(foundOutputs < maxResultsPerBlock) {
                vec2 uv = (vec2(x,y) + vec2(0.5)) * texUnit;

                vec4 value = texture(tex, uv);

                if(value.a > 1.0) {
                    //Insert found finger at currentFingerPosition
                    outputs[maxFingerPosition] = value;
                    maxFingerPosition++;
                    foundOutputs++;
                } else if(value.a > 0.0) {
                    //Insert found tag at currentTagPosition
                    outputs[maxTagPosition] = value;
                    maxTagPosition++;
                    foundOutputs++;
                }
            }
        }
    }

    int currentTagPosition = 0;
    int currentFingerPosition = maxResultsPerBlock;

    vec4 nextValue = vec4(0);
    for(int i = 0; i<maxResultsPerBlock; i++) {
        if(currentTagPosition < maxTagPosition) {
            nextValue = outputs[currentTagPosition];
            currentTagPosition++;
        } else if(currentFingerPosition < maxFingerPosition) {
            nextValue = outputs[currentFingerPosition];
            currentFingerPosition++;
        } else {
            return;
        }

        gl_Position = vec4(-1 + (i+0.5)*(2.0/maxResultsPerBlock), outputLine, 0, 1);
        center = nextValue;
        EmitVertex();
    }
}