#version 150

/**
 * © Janus Bager Kristensen & Rolf Bagge, CAVI Aarhus University, 2014
 */

%USE_DITHERING%

// From vertex shader
smooth in vec2 texCoord;

// From application
uniform sampler2D texture;
uniform sampler2D colorCurve;

// Dithering
uniform float ditheringArea; // The maximal [0;1]-space to search for dithering purposes
uniform float ditheringThreshold; // Dithering turns off if a change larger than this is detected in a dithering area
uniform float randomSeed; // Seed for dithering algorithm, changes every frame

out vec4 outColor;

void main() {
    // Search ditheringArea to collect information about min, max, average colour values
    outColor = texture2D(texture, texCoord);

#ifdef USE_DITHERING
    vec4 centerWeight = vec4(
        fract(sin(dot(texCoord.xy ,vec2(12.9898+randomSeed,78.233))) * 43758.5453),
        fract(sin(dot(texCoord.xy ,vec2(13.9898-randomSeed,78.233))) * 43757.5453),
        fract(sin(dot(texCoord.xy ,vec2(14.9898*randomSeed,78.233))) * 43756.5453),
        1.0);
    vec3 averageColor = vec3(0.0,0.0,0.0);
    vec3 minColor = vec3(9999.0,9999.0,9999.0);
    vec3 maxColor = vec3(-9999.0,-9999.0,-9999.0);
    vec2 lookup = texCoord + (centerWeight.xy * ditheringArea*2.1);
    for (int y = -3; y <= 3; y++){
        for (int x = -2; x <= 2; x++){
            vec3 thisSample = texture2D(texture, lookup+vec2(x*ditheringArea, y*ditheringArea)).rgb;
            averageColor += thisSample;
            minColor = min(minColor, thisSample);
            maxColor = max(maxColor, thisSample);
        }
    }
    averageColor = ceil(255.0 * averageColor / (7.0*5.0))/ 255.0;

    // Perform dithering if required
    if (length(maxColor - minColor) <= ditheringThreshold){
        // Within threshold:
        // Produce a colour that is based on the normal outColor but has a random weighting towards averageColor 
        // while still taking into account minColor and maxColor
        float ceilFloor = fract(sin(dot(texCoord.xy ,vec2(14.9898*randomSeed,78.233))) * 43756.5453);
        centerWeight /= max(1, 10-length(maxColor-minColor));
        outColor = centerWeight*outColor + (1-centerWeight)*vec4(averageColor,outColor.a);
    }
#endif

    // Finally perform colour grading based on lookups in the colour curve
    outColor = vec4(
        texture2D(colorCurve, vec2(outColor.r,0)).r, 
        texture2D(colorCurve, vec2(outColor.g,0)).g, 
        texture2D(colorCurve, vec2(outColor.b,0)).b, 
        outColor.a);
}
