#version 150

/**
 * © Janus Bager Kristensen & Rolf Bagge, CAVI Aarhus University, 2014
 */

#define KERNEL_SIZE 9

//From Java
uniform sampler2D colorMap;
uniform float[KERNEL_SIZE] kernel;

//From vertex shader
smooth in vec2 texCoord;

//Output
out vec4 outColor;

void main() {
    vec2 step = 1.0 / textureSize(colorMap, 0);

    vec2[KERNEL_SIZE] offset = vec2[](
        vec2(-step.x, -step.y), vec2(0.0, -step.y), vec2(step.x, -step.y),
        vec2(-step.x, 0.0),     vec2(0.0, 0.0),     vec2(step.x, 0.0),
        vec2(-step.x, step.y),  vec2(0.0, step.y),  vec2(step.x, step.y)
    );

    vec3 sum = vec3(0.0);
    float kernelSum = 0;

    for( int i=0; i<KERNEL_SIZE; i++ ) {
        vec3 tmp = texture(colorMap, texCoord + offset[i]).rgb;
        sum += tmp * kernel[i];
    }

    outColor = vec4(sum, 1.0);
}