#version 150

/**
 * © Janus Bager Kristensen & Rolf Bagge, CAVI Aarhus University, 2014
 */

vec2 texCoord;
uniform sampler2D colorMap;
uniform float blurSize;

const int samples = %SAMPLES%;

void main() {
    vec4 sum = vec4(0.0);

    for (int x = 0; x<samples; x++){
        for (int y = 0; y<samples; y++){
            vec2 point = vec2(texCoord.xy);
            vec2 diff = vec2(x,y);
            diff -= 0.5*samples;
            diff /= samples/2.0;
            diff *= blurSize;
            sum += texture2D(colorMap, point+diff);
        }
    }

    gl_FragColor = vec4(sum/samples/samples);
}